#include <iostream>
#include <cmath>
#include <string>
#include <algorithm>
#include <cstring>
#include <cstdio>
#include <fstream>
#include <cassert>
#include <map>
#include <set>
#include <vector>
#include <queue>
#include <stack>
#include <functional>
#include <numeric>
#include <ctime>
#include <cstdlib>
#include <sstream>

using namespace std;

#define f first
#define s second
#define mp make_pair
#define pb push_back
#define pii pair<int, int>
#define pll pair<long long, long long>
#define y1 stupid_y1
#define ll long long
#define vi vector<int>
#define forit(it, s) for(__typeof(s.begin()) it = s.begin(); it != s.end(); it++)
#define all(a) a.begin(), a.end()
#define sqr(x) ((x)*(x))
#define sz(a) (int)a.size()
#define file "a"

const int maxn = (int)2e3+11;
const int inf = int(1e9);
const int mod = inf + 7;
const double eps = 1e-9;
const double pi = acos(-1.0);

int dp[maxn][maxn], pr[maxn][maxn];
int n, x;
ll d;
int fact[maxn], inv[maxn];

int calc(int id, int r) {
	if(r < 0) return 0;
	return pr[id][r];
}

int calc(int id, int l, int r) {
	if(l > r) return 0;
	int ans = calc(id, r);
	ans -= calc(id, l-1);
	if(ans < 0) ans += mod;
	return ans;
}

int binpow(int a, int k) {
	if(k == 0) return 1;
	int ans = binpow(a, k / 2);
	ans = 1ll * ans * ans % mod;
	if(k % 2) ans = 1ll * ans * a % mod;
	return ans;
}

int c(ll d, int k) {
	int p = 1, q = inv[k];
	for(int i = 0; i < k; i++) {
		p = 1ll * p * ((d - i) % mod) % mod;
	}
	return 1ll * p * q % mod;
}

bool solve() {
	cin >> n >> d >> x;
	if(n==0 && d == 0 && x == 0) return false;

	dp[0][0] = 1;
	pr[0][0] = 1;
	for(int i = 1; i <= n; i++) pr[0][i] = 1;
	for(int k = 1; k <= n; k++) {
		for(int i = 0; i < k; i++) dp[k][i] = 0;
		for(int i = k; i <= n; i++) {
			int l = i-(x-1);
			int r = i-1;
			l = max(l, 0);
			dp[k][i] = calc(k-1, l, r);
		}
		pr[k][0] = dp[k][0];
		for(int i = 1; i <= n; i++) {
			pr[k][i] = dp[k][i] + pr[k][i-1];
			if(pr[k][i] >= mod) pr[k][i]-=mod;
		}
	}

	int ans = 0;

	for(int k = 1; k <= n; k++) {
		if(k > d) break;
		int temp = c(d, k) * 1ll * dp[k][n] % mod;
		ans = ans + temp;
		if(ans >= mod) ans -= mod;
	}

	cout << ans << endl;

	return true;
}

int main () {

	#ifdef LOCAL
	freopen(file".in", "r", stdin);
	freopen(file".out", "w", stdout);
	#endif

	fact[0] = inv[0] = 1;
	for(int i = 1; i < maxn; i++) {
		fact[i] = 1ll * fact[i-1] * i % mod;
		inv[i] = binpow(fact[i], mod-2);
	}

	while(solve());

	#ifdef LOCAL
	cerr << (double)clock() * 1.0 / CLOCKS_PER_SEC << endl;
	#endif

	return 0;
}


